/*
 
 controller.h ... Controllers/Delegates for Views in ℏClipboard.
 
 Copyright (c) 2009, KennyTM~
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:
 
 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
 * Neither the name of the KennyTM~ nor the names of its contributors may be
   used to endorse or promote products derived from this software without
   specific prior written permission.
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 */


#import <Foundation/NSObject.h>
#import <CoreGraphics/CGGeometry.h>

@class hGestureLayout, NSBundle, NSString, UIButton, UIKBSpecialKeyButton, UICalloutView, NSMutableDictionary, UIView, NSSet;



@interface UICalloutViewShower : NSObject {
	UICalloutView* calloutView;
	NSMutableDictionary* calloutStrings;
	UIView* installView;	// WEAK REFERENCE!
	CGRect boundaryRect;
}
@property(assign) CGRect boundaryRect;
-(id)initWithView:(UIView*)instf;
-(void)dealloc;

-(void)registerButton:(UIButton*)btn withCalloutString:(NSString*)str;
-(void)show:(UIButton*)sender;
-(void)hide;
@end




@interface hGestureLayoutController : NSObject {
	hGestureLayout* view;	// this should be a WEAK REFERENCE to avoid retain cycle!
	NSBundle* bundle;
	BOOL selectState;
	NSUInteger selectIndex;
	NSSet* multicharBlacklist;
	
	BOOL bCaps;
	BOOL bShift;
	BOOL bSymbol;
}
@property(assign) hGestureLayout* view;
@property(retain) NSBundle* bundle;
@property(nonatomic) BOOL bSymbol;
-(id)init;
//-(void)copyText:(NSString*)txt;
//-(void)copyText;
-(void)paste:(NSString*)txt;
//-(void)moveToBeginning;
//-(void)moveToEnd;
//-(void)markSelection:(UIButton*)sender;
//-(void)switchClipboard:(UIKBSpecialKeyButton*)sender;
-(void)test;
-(BOOL)getCaps;
-(BOOL)getSymbol;

@end

