//
//  jpHenkan.m
//  GestureTest
//
// Copyright (c) 2009, NochiNa
// All rights reserved.
//

#import "jpHenkan.h"
#import <UIKit2/UIKeyboardImpl.h>


static sqlite3_stmt *init_statement = nil;

@implementation jpHenkan

static NSArray *romaKataArray;
static NSArray *romaKanaArray;

-(jpHenkan*)initDic
{
	//辞書データを読む
	
	NSString *dictData_path = @"/Library/iKeyEx/Keyboards/Gesture.keyboard/JPDIC.sqlite";

	if(sqlite3_open([dictData_path UTF8String ] ,&dictionaryDB) != SQLITE_OK)
	{
		return;
	}	
	pobox_cands = [[NSMutableArray alloc]init];
	[self initRomaKanaArray];
	
	return self;
}

-(int)getkanaIndex:(NSString*)yomi
{
	NSString * kanaIndexStr = [NSString stringWithString:KANA_INDEX];
	int kanaIndex = 0;
	
	NSRange resultRange;
	resultRange = [kanaIndexStr rangeOfString:[yomi substringToIndex:1] options:NSLiteralSearch range:NSMakeRange(0,[kanaIndexStr length]) ];
	if(NSNotFound != resultRange.location)
	{
		return resultRange.location;
	}
	else
	{
		return 0;
	}
	


}

-(void)clearCandidate
{
	[pobox_cands removeAllObjects];

}

-(void)setCandidate:(NSString*)in_yomi mode:(BOOL)mode
{
	//辞書検索
	[pobox_cands removeAllObjects];

	if([in_yomi length] == 0)
	{
		return;
	}
	
	//if (init_statement == nil) 
	//{
		NSString *  NSStringSql;
		if(mode == YES)
		{
		  NSStringSql = [NSString stringWithFormat:@"SELECT WORD FROM DICTIONARY WHERE YOMI COLLATE NOCASE like '%@%%'",in_yomi];
		}
		else
		{
		 NSStringSql = [NSString stringWithFormat:@"SELECT DISTINCT WORD FROM DICTIONARY WHERE ASSOCIATION = '%@'",in_yomi];
		}
		
		const char *sql = [NSStringSql UTF8String];

		 //[[UIKeyboardImpl sharedInstance] addInputString:@"DO!SQL"];


		if(sqlite3_prepare_v2(dictionaryDB,sql,-1,&init_statement,NULL) == SQLITE_OK)
		{
		//	[[UIKeyboardImpl sharedInstance] addInputString:@"OK!SQL"];

			while((sqlite3_step(init_statement)==SQLITE_ROW) &&([pobox_cands count] < 30))
			{
				NSString* henkan = [NSString stringWithCString:sqlite3_column_text(init_statement,0) encoding:NSUTF8StringEncoding];
				//本来はDB側distinctでやるべきなのだけど、なんかモッサリしてしまったのでこちらでやります
				BOOL result;
				result =  YES;
				for(int i = 0;i < [pobox_cands count];i++)
				{
					NSString * checkString = [pobox_cands objectAtIndex:i];
					if([checkString compare:henkan]==NSOrderedSame)
					{
						result = NO;
						break;
					}
				}
				if(result == YES)
				{
					[pobox_cands addObject:henkan];
				}
			}
		}
		else
		{
		//[[UIKeyboardImpl sharedInstance] addInputString:@"FAIL!SQL"];
		}
		//sqlite3_reset(init_statement);
		sqlite3_finalize(init_statement);
	//}

		if(mode == YES)
		{
	
			NSMutableString* romaKanaStr = [NSMutableString stringWithString:in_yomi];
			romaKanaStr = [self romaKanaChange:romaKanaStr];
			[pobox_cands addObject:romaKanaStr];
	
			NSMutableString* romaKataStr = [NSMutableString stringWithString:in_yomi];
			romaKataStr = [self romaKataChange:romaKataStr];
			[pobox_cands addObject:romaKataStr];
		
	
			//if([pobox_cands count]==0)
			//{
			//一番後ろにそれそのものをつける
				[pobox_cands addObject:in_yomi];
			//}
		}
	return;
}


-(NSArray*)getCandidate
{
 	return pobox_cands;
}


-(void)dealloc
{
	//sqlite3_finalize(init_statement);
	[romaKanaArray release];
	[romaKataArray release];
	[pobox_cands removeAllObjects];
	[pobox_cands release];
	[dictIndex removeAllObjects];
	[dictIndex release];
	[super dealloc];
}






-(NSMutableString*)romaKanaChange:(NSMutableString*)romaKana
{


	//順に文字列の入れ替え
	int romaKanaArrayCount;
	romaKanaArrayCount =[romaKanaArray count] ;
	
	for(int nIndex = 0;nIndex < romaKanaArrayCount;nIndex=nIndex+2)
	{
		romaKana= [romaKana stringByReplacingOccurrencesOfString: 
		 [romaKanaArray objectAtIndex:nIndex]  withString:[romaKanaArray objectAtIndex:nIndex+1]  ];
	}
	
	return romaKana;
}

-(NSMutableString*)romaKataChange:(NSMutableString*)romaKata
{


	//順に文字列の入れ替え
	int romaKataArrayCount;
	romaKataArrayCount =[romaKataArray count] ;
	
	for(int nIndex = 0;nIndex < romaKataArrayCount;nIndex=nIndex+2)
	{
		romaKata= [romaKata stringByReplacingOccurrencesOfString: 
		 [romaKataArray objectAtIndex:nIndex]  withString:[romaKataArray objectAtIndex:nIndex+1]   ];
	}
	

	
	return romaKata;
}


-(void)initRomaKanaArray
{

romaKanaArray = [[NSArray alloc] initWithObjects:
	@"-",	@"ー",
	@"n'",	@"ん",

	@"xtsu",@"っ",

	@"kk",@"っk",
	@"ss",@"っs",
	@"tt",@"っt",
	@"hh",@"っh",
	@"mm",@"っm",
	@"yy",@"っy",
	@"rr",@"っr",
	@"ww",@"っw",

	@"bya",	@"びゃ",
	@"bye",	@"びぇ",
	@"byi",	@"びぃ",
	@"byo",	@"びょ",
	@"byu",	@"びゅ",
	@"cha",	@"ちゃ",
	@"che",	@"ちぇ",
	@"chi",	@"ち",
	@"cho",	@"ちょ",
	@"chu",	@"ちゅ",
	@"dha",	@"でゃ",
	@"dhe",	@"でぇ",
	@"dhi",	@"でぃ",
	@"dho",	@"でょ",
	@"dhu",	@"でゅ",
	@"dya",	@"ぢゃ",
	@"dye",	@"ぢぇ",
	@"dyi",	@"ぢぃ",
	@"dyo",	@"ぢょ",
	@"dyu",	@"ぢゅ",
	@"gya",	@"ぎゃ",
	@"gye",	@"ぎぇ",
	@"gyi",	@"ぎぃ",
	@"gyo",	@"ぎょ",
	@"gyu",	@"ぎゅ",
	@"hya",	@"ひゃ",
	@"hye",	@"ひぇ",
	@"hyi",	@"ひぃ",
	@"hyo",	@"ひょ",
	@"hyu",	@"ひゅ",
	@"kya",	@"きゃ",
	@"kye",	@"きぇ",
	@"kyi",	@"きぃ",
	@"kyo",	@"きょ",
	@"kyu",	@"きゅ",
	@"mya",	@"みゃ",
	@"mye",	@"みぇ",
	@"myi",	@"みぃ",
	@"myo",	@"みょ",
	@"myu",	@"みゅ",
	@"rya",	@"りゃ",
	@"rye",	@"りぇ",
	@"ryi",	@"りぃ",
	@"ryo",	@"りょ",
	@"ryu",	@"りゅ",
	@"pya",	@"ぴゃ",
	@"pye",	@"ぴぇ",
	@"pyi",	@"ぴぃ",
	@"pyo",	@"ぴょ",
	@"pyu",	@"ぴゅ",
	@"nya",	@"にゃ",
	@"nye",	@"にぇ",
	@"nyi",	@"にぃ",
	@"nyo",	@"にょ",
	@"nyu",	@"にゅ",
	@"sha",	@"しゃ",
	@"she",	@"しぇ",
	@"shi",	@"し",
	@"sho",	@"しょ",
	@"shu",	@"しゅ",
	@"sya",	@"しゃ",
	@"sye",	@"しぇ",
	@"syi",	@"しぃ",
	@"syo",	@"しょ",
	@"syu",	@"しゅ",
	@"tha",	@"てゃ",
	@"the",	@"てぇ",
	@"thi",	@"てぃ",
	@"tho",	@"てょ",
	@"thu",	@"てゅ",	
	@"tsu",	@"つ",
	@"tya",	@"ちゃ",
	@"tye",	@"ちぇ",
	@"tyi",	@"ちぃ",
	@"tyo",	@"ちょ",
	@"tyu",	@"ちゅ",
	@"xtu",	@"っ",
	@"xwa",	@"ゎ",
	@"zya",	@"じゃ",
	@"zye",	@"じぇ",
	@"zyi",	@"じぃ",
	@"zyo",	@"じょ",
	@"zyu",	@"じゅ",
	
	
	@"ba",	@"ば",
	@"be",	@"べ",
	@"bi",	@"び",
	@"bo",	@"ぼ",
	@"bu",	@"ぶ",
	@"da",	@"だ",
	@"de",	@"で",
	@"di",	@"ぢ",
	@"do",	@"ど",
	@"du",	@"づ",
	@"fa",	@"ふぁ",
	@"fe",	@"ふぇ",
	@"fi",	@"ふぃ",
	@"fo",	@"ふぉ",
	@"fu",	@"ふ",
	@"ga",	@"が",
	@"ge",	@"げ",
	@"gi",	@"ぎ",
	@"go",	@"ご",
	@"gu",	@"ぐ",
	@"ha",	@"は",
	@"he",	@"へ",
	@"hi",	@"ひ",
	@"ho",	@"ほ",
	@"hu",	@"ふ",
	@"ja",	@"じゃ",
	@"je",	@"じぇ",
	@"ji",	@"じ",
	@"jo",	@"じょ",
	@"ju",	@"じゅ",
	@"ka",	@"か",
	@"ke",	@"け",
	@"ki",	@"き",
	@"ko",	@"こ",
	@"ku",	@"く",
	@"ma",	@"ま",
	@"me",	@"め",
	@"mi",	@"み",
	@"mo",	@"も",
	@"mu",	@"む",
	@"na",	@"な",
	@"ne",	@"ね",
	@"ni",	@"に",
	@"no",	@"の",
	@"nu",	@"ぬ",
	@"pa",	@"ぱ",
	@"pe",	@"ぺ",
	@"pi",	@"ぴ",
	@"po",	@"ぽ",
	@"pu",	@"ぷ",
	@"ra",	@"ら",
	@"re",	@"れ",
	@"ri",	@"り",
	@"ro",	@"ろ",
	@"ru",	@"る",
	@"sa",	@"さ",
	@"se",	@"せ",
	@"si",	@"し",
	@"so",	@"そ",
	@"su",	@"す",
	@"ta",	@"た",
	@"te",	@"て",
	@"ti",	@"ち",
	@"to",	@"と",
	@"tu",	@"つ",
	@"wa",	@"わ",
	@"we",	@"うぇ",
	@"wi",	@"うぃ",
	@"wo",	@"を",
	@"xa",	@"ぁ",
	@"xe",	@"ぇ",
	@"xi",	@"ぃ",
	@"xo",	@"ぉ",
	@"xu",	@"ぅ",
	@"ya",	@"や",
	@"yu",	@"ゆ",
	@"yo",	@"よ",
	@"za",	@"ざ",
	@"ze",	@"ぜ",
	@"zi",	@"じ",
	@"zo",	@"ぞ",
	@"zu",	@"す",
	
	@"a",	@"あ",
	@"i",	@"い",
	@"u",	@"う",
	@"e",	@"え",
	@"o",	@"お",

	@"n",	@"ん"
	,nil];


romaKataArray = [[NSArray alloc] initWithObjects:
	@"-",	@"ー",
	@"n'",	@"ン",

	@"xtsu",@"ッ",

	@"kk",@"ッk",
	@"ss",@"ッs",
	@"tt",@"ッt",
	@"hh",@"ッh",
	@"mm",@"ッm",
	@"yy",@"ッy",
	@"rr",@"ッr",
	@"ww",@"ッw",


	@"bya",	@"ビャ",
	@"bye",	@"ビェ",
	@"byi",	@"ビィ",
	@"byo",	@"ビョ",
	@"byu",	@"ビュ",
	@"cha",	@"チャ",
	@"che",	@"チェ",
	@"chi",	@"チ",
	@"cho",	@"チョ",
	@"chu",	@"チュ",
	@"dha",	@"デャ",
	@"dhe",	@"デェ",
	@"dhi",	@"ディ",
	@"dho",	@"デョ",
	@"dhu",	@"デュ",
	@"dya",	@"ヂャ",
	@"dye",	@"ヂェ",
	@"dyi",	@"ヂィ",
	@"dyo",	@"ヂョ",
	@"dyu",	@"ヂュ",
	@"gya",	@"ギャ",
	@"gye",	@"ギェ",
	@"gyi",	@"ギィ",
	@"gyo",	@"ギョ",
	@"gyu",	@"ギュ",
	@"hya",	@"ヒャ",
	@"hye",	@"ヒェ",
	@"hyi",	@"ヒィ",
	@"hyo",	@"ヒョ",
	@"hyu",	@"ヒュ",
	@"kya",	@"キャ",
	@"kye",	@"キェ",
	@"kyi",	@"キィ",
	@"kyo",	@"キョ",
	@"kyu",	@"キュ",
	@"mya",	@"ミャ",
	@"mye",	@"ミェ",
	@"myi",	@"ミィ",
	@"myo",	@"ミョ",
	@"myu",	@"ミュ",
	@"nya",	@"ニャ",
	@"nye",	@"ニェ",
	@"nyi",	@"ニィ",
	@"nyo",	@"ニョ",
	@"nyu",	@"ニュ",
	@"pya",	@"ピャ",
	@"pye",	@"ピェ",
	@"pyi",	@"ピィ",
	@"pyo",	@"ピョ",
	@"pyu",	@"ピュ",
	@"rya",	@"リャ",
	@"rye",	@"リェ",
	@"ryi",	@"リィ",
	@"ryo",	@"リョ",
	@"ryu",	@"リュ",
	@"sha",	@"シャ",
	@"she",	@"シェ",
	@"shi",	@"シ",
	@"sho",	@"ショ",
	@"shu",	@"シュ",
	@"sya",	@"シャ",
	@"sye",	@"シェ",
	@"syi",	@"シィ",
	@"syo",	@"ショ",
	@"syu",	@"シュ",
	@"tha",	@"テャ",
	@"the",	@"テェ",
	@"thi",	@"ティ",
	@"tho",	@"テョ",
	@"thu",	@"テュ",
	@"tsu",	@"ツ",
	@"tya",	@"チャ",
	@"tye",	@"チェ",
	@"tyi",	@"チィ",
	@"tyo",	@"チョ",
	@"tyu",	@"チュ",
	@"xtu",	@"ッ",
	@"xwa",	@"ヮ",
	@"zya",	@"ジャ",
	@"zye",	@"ジェ",
	@"zyi",	@"ジィ",
	@"zyo",	@"ジョ",
	@"zyu",	@"ジュ",



	@"ba",	@"バ",
	@"be",	@"ベ",
	@"bi",	@"ビ",
	@"bo",	@"ボ",
	@"bu",	@"ブ",
	@"da",	@"ダ",
	@"de",	@"デ",
	@"di",	@"ヂ",
	@"do",	@"ド",
	@"du",	@"ヅ",
	@"fa",	@"ファ",
	@"fe",	@"フェ",
	@"fi",	@"フィ",
	@"fo",	@"フォ",
	@"fu",	@"フ",
	@"ga",	@"ガ",
	@"ge",	@"ゲ",
	@"gi",	@"ギ",
	@"go",	@"ゴ",
	@"gu",	@"グ",
	@"ha",	@"ハ",
	@"he",	@"ヘ",
	@"hi",	@"ヒ",
	@"ho",	@"ホ",
	@"hu",	@"フ",
	@"ja",	@"ジャ",
	@"je",	@"ジェ",
	@"ji",	@"ジ",
	@"jo",	@"ジョ",
	@"ju",	@"ジュ",
	@"ka",	@"カ",
	@"ke",	@"ケ",
	@"ki",	@"キ",
	@"ko",	@"コ",
	@"ku",	@"ク",
	@"ma",	@"マ",
	@"me",	@"メ",
	@"mi",	@"ミ",
	@"mo",	@"モ",
	@"mu",	@"ム",
	@"na",	@"ナ",
	@"ne",	@"ネ",
	@"ni",	@"ニ",
	@"no",	@"ノ",
	@"nu",	@"ヌ",
	@"pa",	@"パ",
	@"pe",	@"ペ",
	@"pi",	@"ピ",
	@"po",	@"ポ",
	@"pu",	@"プ",
	@"ra",	@"ラ",
	@"re",	@"レ",
	@"ri",	@"リ",
	@"ro",	@"ロ",
	@"ru",	@"ル",
	@"sa",	@"サ",
	@"se",	@"セ",
	@"si",	@"シ",
	@"so",	@"ソ",
	@"su",	@"ス",
	@"ta",	@"タ",
	@"te",	@"テ",
	@"ti",	@"チ",
	@"to",	@"ト",
	@"tu",	@"ツ",
	@"wa",	@"ワ",
	@"we",	@"ウェ",
	@"wi",	@"ウィ",
	@"wo",	@"ヲ",
	@"xa",	@"ァ",
	@"xe",	@"ェ",
	@"xi",	@"ィ",
	@"xo",	@"ォ",
	@"xu",	@"ゥ",
	@"ya",	@"ヤ",
	@"yu",	@"ユ",
	@"yo",	@"ヨ",
	@"za",	@"ザ",
	@"ze",	@"ゼ",
	@"zi",	@"ジ",
	@"zo",	@"ゾ",
	@"zu",	@"ス",
	
	@"a",	@"ア",
	@"i",	@"イ",
	@"u",	@"ウ",
	@"e",	@"エ",
	@"o",	@"オ",

	@"n",	@"ン"
	,nil];

}
@end

/*
@implementation dicData
@synthesize yomi,henkan;

-(dicData*)initWithValue:(NSString*)in_yomi henkan:(NSString*)in_henkan 
{
	yomi = [[NSString alloc]initWithString:in_yomi];
	henkan = [[NSString alloc]initWithString:in_henkan];
	return self;
}

-(void)dealloc
{
	[yomi release];
	[henkan release];
	[super dealloc];
}


@end
*/
