/*
 
 views.h ... Views and Layouts in ℏClipboard.
 
 Copyright (c) 2009, KennyTM~
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:
 
 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
 * Neither the name of the KennyTM~ nor the names of its contributors may be
   used to endorse or promote products derived from this software without
   specific prior written permission.
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 */


#import <UIKit/UIKit.h>
#import <UIKit2/UIKeyboardLayout.h>


#define DEFAULT_NB_SECTORS 8					// Number of sectors
#define DEFAULT_TIME_STEP 20		// Capture interval in ms
#define DEFAULT_PRECISION 8		// Precision of catpure in pixels
#define DEFAULT_FIABILITY 30		// Default fiability level

#define D_MATCH 1
#define G_MATCH 2
#define O_MATCH 3
#define P_MATCH 4
#define Q_MATCH 5
#define S_MATCH 6
#define FIVE_MATCH 7
#define SIX_MATCH 8
#define H_MATCH 9
#define M_MATCH 10

//@class hCClipboardDataSource, Clipboard, UIKBButtonsGroup, UICalloutView, hGestureLayoutController, UICalloutViewShower, UIKBSpecialKeyButton;

@class UIKBButtonsGroup, UICalloutView, hGestureLayoutController, UICalloutViewShower, UIKBSpecialKeyButton;

// a UITableView that displays clipboard data.
@interface GestureView : UIView{//<UIViewDelegate> {
//@interface GestureView : UIImageView<UIImageViewDelegate> {
//	hCClipboardDataSource* datasource;
	id _target;
	SEL _action;
//	BOOL flash0thRow;
//	UILabel* emptyClipboardIndicator;
	NSMutableArray *moves;						// Mouse gestures
	CGPoint lastPoint;					// Last mouse point
	//private var mouseZone:InteractiveObject;		// Mouse zone
	uint captureDepth;					// Current capture depth 
	NSMutableArray *gestures;						// Gestures to match
	NSMutableArray *gesturesNumber;						// Gestures to match
	NSMutableArray *gesturesSymbol;						// Gestures to match
	CGRect rect;						// Rectangle zone
	NSMutableArray *points;						// Mouse points 
	
//	protected var timer:Timer;						// Timer
	float sectorRad;					// Angle of one sector		
	NSMutableArray *anglesMap;					// Angles map 		
	
	UILabel * capsInfo;
	
}
-(id)initWithFrame:(CGRect)frm;
//@property(retain) Clipboard* clipboard;
//-(BOOL)isDefaultClipboard;
-(void)setTarget:(id)target action:(SEL)action;
//-(void)setPlaceholderText:(NSString*)txt;

//-(void)flashFirstRow;
//-(BOOL)switchClipboard;
@end




// a transparent vertical toolbar
@interface hCVerticalToolBar : UIView {
	NSUInteger columns;
}
@property(assign) NSUInteger columns;
-(void)layoutSubviews;
-(UIButton*)addButtonWithImage:(UIImage*)img target:(id)target action:(SEL)action;
@end



// the keyboard layout for ℏClipboard.
@interface hGestureLayout : UIKeyboardLayout {
@package
	hCVerticalToolBar* toolbar;
	GestureView* gestureView;
	UICalloutViewShower* calloutShower;
	UIButton* copyBtn;
	
@protected
	UIButton* markSelBtn;
	UIImageView* backgroundView;
	UIKBButtonsGroup* spBtnGroup;
	hGestureLayoutController* controller;
	UIKeyboardAppearance keyboardAppearance;
	UIKBSpecialKeyButton* switchClipboardButton;
	
	
}
-(id)initWithFrame:(CGRect)frm;
-(void)layoutSubviews;
@property(readonly,assign) GestureView* gestureView;
@end
	

@interface gestureInfo : NSObject
{
	NSString * datas;
	NSMutableArray* moves;
	//SEL matchHandler;
	uint matchHandler;
	CGPoint lastPoint;
	CGRect rect;
	uint cost;
}
@property(retain,nonatomic) NSString *datas;
@property(retain,nonatomic) NSMutableArray *moves;
@property(nonatomic) uint matchHandler;
@property(nonatomic) uint cost;
@property(nonatomic) CGPoint lastPoint;
@property(nonatomic) CGRect rect;


@end
	